/////////////////////////////////////////////////////////////////////////////////

// Original obtained from ShaderToy.com
// Adapted, trivialy, for VGHD by TheEmu.

uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

// Use defines here rather than edit the body of the code.

#define iGlobalTime u_Elapsed
#define iResolution u_WindowSize

/////////////////////////////////////////////////////////////////////////////////

vec3 densityToColor(float density) {
    return mix(vec3(0.1, 0.2, 0.3), mix(vec3(0.2, 0.6, 1.0), vec3(0.8, 0.82, 1.0), density), density);
}

vec2 coord(vec2 pix, vec2 res) {
	return (pix - res / 2.0) / min(res.x, res.y) * 2.0;
}

vec2 wave(vec2 axis, float freq, float amount, vec2 loc) {
    return loc + sin(iGlobalTime + dot(normalize(axis), loc) / freq) * amount;
}

float density(vec2 loc) {
    return 1.0 / (length(loc) + 1.0);
}

void main ( void )
{
	gl_FragColor = vec4(densityToColor(density(wave(vec2(-2.0, 4.0), 0.01, 0.3, wave(vec2(9.0, -11.0), 0.2, 0.3, wave(vec2(4.0, 7.0), 0.07, 0.1, coord(gl_FragCoord.xy, iResolution.xy)))))),1.0);
}